﻿var extractionWizard = {
    context: $("#extractionWizard"),
    selectedQuestionsTable: null,
    currentData: null,
    refreshDataTable: function (data) {
        $("#ExtractTaskConfiguration_JsonSelectedQuestions", extractionWizard.context).val(data);
        extractionWizard.currentData = data;

        if (extractionWizard.selectedQuestionsTable) {
            extractionWizard.selectedQuestionsTable.a4datatable("option", "ajaxParams", { "variableData": data, "sort": false });
            extractionWizard.selectedQuestionsTable.a4datatable("refresh");
        }
        else {
            extractionWizard.initializeDataTable();
        }
    },
    initializeDataTable: function () {
        this.selectedQuestionsTable = $(".h-selectedQuestionsTable").a4datatable({
            ajaxAction: a4.getProjectAction("GetSelectedQuestions", "Extraction"),
            ajaxParams: { "variableData": extractionWizard.currentData },
            columns: [
                { "Name": "Id", "Title": resources.Id, "Data": "Id", "Visible": false },
                { "Name": "Name", "Title": resources.Question, "Data": "Name", "Visible": false },
                { "Name": "IsOpenEnd", "Title": null, "Data": "IsOpenEnd", "Visible": false },
                { "Name": "IsSystemVariable", "Title": null, "Data": "IsSystemVariable", "Visible": false },
                { "Name": "FieldLength", "Title": null, "Data": "FieldLength", "Visible": false },
                { "Name": "DisplayName", "Title": resources.Question, "Data": "DisplayName", "Width": "70%" },
                { "Name": "RecordPosition", "Title": resources.Record, "Data": "RecordPosition", "Visible": extractionFormat == Enum.DtsTypes.Txt, "Width": "12%" },
                { "Name": "ColumnPosition", "Title": resources.Column, "Data": "ColumnPosition", "Visible": extractionFormat == Enum.DtsTypes.Txt, "Width": "12%" },
            ],
            allowRowSelection: true,
            displayColumnSelector: false,
            toolBarItems: extractionWizard.getToolBarItems(),
            stateKey: "SelectedQuestions",
            contextMenuItems: extractionWizard.getContextMenuItems(),
            toolBarClick: function (event, data) {
                var rows = data.rows;
                var action = data.action;

                switch (action) {
                    case "select":
                        extractionWizard.showQuestionsSelector();
                        break;

                    case "calculateAll":
                        extractionWizard.calculateAll();
                        break;

                    case "reset":
                        extractionWizard.resetPositions();
                        break;

                    case "delete":
                        extractionWizard.deleteItems(rows);
                        break;

                    case "calculate":
                        extractionWizard.calculatePositions(rows);
                        break;
                }
            },
            contextMenuClick: function (event, data) {
                var row = data.row;
                var action = data.action;

                switch (action) {
                    case "moveUp":
                        extractionWizard.moveItems([row], false);
                        break;

                    case "moveDown":
                        extractionWizard.moveItems([row], true);
                        break;

                    case "moveTo":
                        extractionWizard.showMoveToDialog(row, function (moveDown, moveToVariable) {
                            extractionWizard.moveToItems([row], moveToVariable, moveDown);
                        });
                        break;

                    case "editPositions":
                        extractionWizard.showEditPositionDialog(row);
                        break;

                    case "delete":
                        extractionWizard.deleteItems([row]);
                        break;
                }
            }
        });
    },
    selectQuestions: function (selectedQuestions) {
        if (selectedQuestions) {
            var params = {
                dtsType: $("#DtsType", extractionWizard.context).val(),
                selectedQuestions: selectedQuestions,
                currentData: JSON.parse(extractionWizard.currentData),
                includeOpenEnds: $("#ExtractTaskConfiguration\\.OpenEndDispositionValue_InTheRecord", extractionWizard.context).is(':checked'),
                openEndLength: $(".v-openEndLenght", extractionWizard.context).val()
            };

            a4.callServerMethod(a4.getProjectAction("GetQuestionsEditorData", "Extraction"), params,
                function (result) {
                    extractionWizard.refreshDataTable(JSON.stringify(result));
                },
                null,
                {
                    async: false
                });
        }
        else
        {
            extractionWizard.refreshDataTable(JSON.stringify([]));
        }
    },
    showQuestionsSelector: function () {
        var questionsSelectorParams = {
            questions: "",
            showSystemVariables: true,
            showFilters: true,
            limitRowCount: 0,
            questionSelectorType: Enum.QuestionSelectorType.Extraction
        };

        modalDialog.showWindow(a4.getProjectAction("QuestionsSelector", "Shared", questionsSelectorParams), 620, 950);
    },
    moveItems: function (items, moveDown) {
        var variables = JSON.parse(extractionWizard.currentData);

        if (moveDown) {
            variables = variables.reverse();
        }

        var index = 0;
        var foundIndex = 0;
        var tmp = null;

        _.each(variables, function (v) {
            if (index != 0 && (foundIndex = _.findIndex(items, function (i) { return extractionWizard.variablesEqual(v, i); })) != -1) {
                tmp = variables[index];
                variables[index] = variables[index - 1];
                variables[index - 1] = tmp;
            }

            index++;
        });

        if (moveDown) {
            variables = variables.reverse();
        }

        extractionWizard.refreshDataTable(JSON.stringify(variables));
    },
    moveToItems: function (items, source, moveDown) {
        var variables = JSON.parse(extractionWizard.currentData);

        if (moveDown)
        {
            variables = variables.reverse();
        }

        var sourceIndex = _.findIndex(variables, function (v) { return extractionWizard.variablesEqual(v, source); });
        var foundIndex = null;
        var tmp = null;

        if (sourceIndex > -1)
        {
            _.each(items, function (i) {
                if ((foundIndex = _.findIndex(variables, function (v) { return extractionWizard.variablesEqual(v, i); })) != -1 && foundIndex != sourceIndex)
                {
                    tmp = variables[sourceIndex];
                    variables.splice(sourceIndex, 0, variables[foundIndex]);

                    if (sourceIndex <= foundIndex)
                        foundIndex += 1;

                    variables.splice(foundIndex, 1);
                }
            });

            if (moveDown) {
                variables = variables.reverse();
            }

            extractionWizard.refreshDataTable(JSON.stringify(variables));
        }
    },
    showMoveToDialog: function (itemToMove, callback) {
        var moveContainer = $("#moveToPanel").clone();
        var container = $('<div id="MoveVariableToPanel">').append(moveContainer.html().replace(/moveBeforeLocation/g, "moveBeforeLocationEdit").replace(/moveAfterLocation/g, "moveAfterLocationEdit"));

        var initContentFunction = function () {
            var editor = $("#MoveVariableToPanel");

            // exclude itemToMove from data
            var data = JSON.parse(extractionWizard.currentData)
                .filter(function (v) { return !extractionWizard.variablesEqual(v, itemToMove); });

            // use Index as valueProperty as no single property uniquely identifies a variable
            data.forEach(function (v, index) { return v.Index = index; });

            $(".v-moveToVariable", editor).a4autocomplete({
                data: data,
                valueProperty: "Index",
                labelProperty: "DisplayName"
            });
        }

        var validateContentFunction = function () {
            var editor = $("#MoveVariableToPanel");
            var valid = ($(".v-moveToVariable", editor).val() != "");

            if (!valid) {
                a4.showErrorMessage(resources.SelectQuestion);
            }

            return valid;
        }

        modalDialog.showConfirmDialog(
        {
            "Title": resources.MoveTo,
            "Message": container
        },
        function () {
            var editor = $("#MoveVariableToPanel");
            var location = $(".v-moveToLocation:checked", editor).val();
            var variable = $(".v-moveToVariable", container).a4autocomplete("getValue");
            callback(location == "Below", variable);
        }
        , 260, 450, false, null,
        { initFunction: initContentFunction, validateFunction: validateContentFunction });
    },
    showEditPositionDialog: function (item, callback) {
        var variables = JSON.parse(extractionWizard.currentData);
        var variable = _.find(variables, function (v) { return extractionWizard.variablesEqual(v, item); });

        if (variable != null) {
            var editContainer = $("#editPositionPanel").clone();
            var container = $('<div id="EditPanel">').append(editContainer.html());

            var initContentFunction = function () {
                var editor = $("#EditPanel");
                $(".v-record", editor).val(variable.RecordPosition);
                $(".v-position", editor).val(variable.ColumnPosition);
            }

            var validateContentFunction = function () {
                var editor = $("#EditPanel");
                var valid = false;
                var intRegex = /^\d+$/;
                var recordLabel = $(".v-recordContent span", editor).text();
                var positionLabel = $(".v-positionContent span", editor).text();

                if ($(".v-record", editor).val() == "")
                    a4.showErrorMessage(resources.FieldRequired.replace("{0}", recordLabel));

                else if ($(".v-position", editor).val() == "")
                    a4.showErrorMessage(resources.FieldRequired.replace("{0}", positionLabel));

                else if (!intRegex.test($(".v-record", editor).val()))
                    a4.showErrorMessage(resources.IsNotAInt + " '" + recordLabel + "'");

                else if (!intRegex.test($(".v-position", editor).val()))
                    a4.showErrorMessage(resources.IsNotAInt + " '" + positionLabel + "'");

                else
                    valid = true;

                return valid;
            }

            var editResources = {
                "Title": resources.EditPositions,
                "Message": container
            };

            modalDialog.showConfirmDialog(editResources,
                function () {
                    var editor = $("#EditPanel");
                    variable.RecordPosition = parseInt($(".v-record", editor).val(), 10);
                    variable.ColumnPosition = parseInt($(".v-position", editor).val(), 10);
                    extractionWizard.refreshDataTable(JSON.stringify(variables));
                }
                , 260, 400, false, null,
                { initFunction: initContentFunction, validateFunction: validateContentFunction });
        }
    },
    deleteItems: function (items) {
        var variables = JSON.parse(extractionWizard.currentData);

        _.each(items, function (i) {
            variables = _.reject(variables, function (v) { return extractionWizard.variablesEqual(v, i); });
        });

        extractionWizard.refreshDataTable(JSON.stringify(variables));
    },
    calculateAll: function () {
        extractionWizard.selectQuestions(JSON.parse(extractionWizard.currentData));
        var variables = JSON.parse(extractionWizard.currentData);
        var start = 1;

        _.each(variables, function (v) {
            v.RecordPosition = v.RecordPos || 1;
            v.ColumnPosition = start;
            start += v.FieldLength;
        });

        extractionWizard.refreshDataTable(JSON.stringify(variables));
    },
    calculatePositions: function (items) {
        var variables = JSON.parse(extractionWizard.currentData);
        var start = 1;
        var index = 0;

        _.each(items, function (i) {
            index = _.findIndex(variables, function (v) { return extractionWizard.variablesEqual(v, i); });
            variables[index].RecordPosition = variables[index].RecordPos || 1;

            if (index > 0)
                variables[index].ColumnPosition = variables[index - 1].ColumnPosition + variables[index - 1].FieldLength;
            else
                variables[index].ColumnPosition = start;
        });

        extractionWizard.refreshDataTable(JSON.stringify(variables));
    },
    resetPositions: function () {
        var variables = JSON.parse(extractionWizard.currentData);

        _.each(variables, function (v) {
            v.RecordPosition = "";
            v.ColumnPosition = "";
        });

        extractionWizard.refreshDataTable(JSON.stringify(variables));
    },
    getContextMenuItems: function () {
        return [{ "Action": "moveUp", "Label": resources.MoveUp, "DisplayCondition": function (data) { return extractionWizard.selectedQuestionsTable.a4datatable('getDisplayedRecords') > 1; } },
                { "Action": "moveDown", "Label": resources.MoveDown, "DisplayCondition": function (data) { return extractionWizard.selectedQuestionsTable.a4datatable('getDisplayedRecords') > 1; } },
                { "Action": "moveTo", "Label": resources.MoveTo, "DisplayCondition": function (data) { return extractionWizard.selectedQuestionsTable.a4datatable('getDisplayedRecords') > 3; } },
                { "Action": "editPositions", "Label": resources.EditPositions, "DisplayCondition": function (data) { return extractionFormat == Enum.DtsTypes.Txt; } },
                { "Action": "delete", "Label": resources.Delete }];
    },
    getToolBarItems: function () {
        var items = [];
        var extractionFormatTxt = function (data) { return extractionFormat == Enum.DtsTypes.Txt; };

        items = [{ "Action": "select", "Label": resources.SelectQuestions, "DisplayMode": dataTables.itemDisplayMode.always },
                { "Action": "calculateAll", "Label": resources.CalculateAllPositions, "DisplayCondition": extractionFormatTxt, "DisplayMode": dataTables.itemDisplayMode.nonSelected },
                { "Action": "reset", "Label": resources.ResetPositions, "DisplayCondition": extractionFormatTxt, "DisplayMode": dataTables.itemDisplayMode.nonSelected },
                { "Action": "delete", "Label": resources.Delete },
                { "Action": "calculate", "Label": resources.CalculatePositions, "DisplayCondition": extractionFormatTxt }];


        return items;
    },
    initialize: function () {
        a4.initializeInputs(this.context);
        a4.setInputFocus(this.context);

        $(".v-dichotomizedMultipleOptions", extractionWizard.context).toggle($(".v-dichotomizedMultiple", extractionWizard.context).is(":checked"));
        $(".v-startNumberingRespondentAtSection", extractionWizard.context).toggle($(".v-useStartNumberingRespondent", extractionWizard.context).is(":checked"));
        $(".v-questionsSelectorSection", extractionWizard.context).toggle(!$(".v-extractAllFields").is(":checked"));
   
        if (extractionFormat == Enum.DtsTypes.Txt)
            extractionWizard.validateOpenEndForControl();
    },
    bindEvents: function () {
        extractionWizard.context.on("change", "input[type='radio'][name='ExtractTaskConfiguration.ResponsesSubsetType']", function () {
            var parent = $(this).closest(".field");
            var subset = $(".h-responseSubset", parent).is(":checked");
            $(".h-editFilter", parent).toggle(subset);
            $(".v-caseFilterSummary", parent).toggle(subset);
        });

        extractionWizard.context.on("click", ".h-editFilter", function () {
            var params = {
                caseFilterModel: $(".v-casefilter", extractionWizard.context).val()
            };
            
            modalDialog.showWindow(a4.getProjectAction("ExtractionCaseFilter", "Extraction", params), 900, 1300, {
                beforeClose: function () {
                    var filterSelector = $('.fancybox-iframe').contents();
                    var confirmed = filterSelector.find(".v-confirmed").val();

                    if (confirmed)
                        $(".v-casefilter").val($(".v-casefilter", filterSelector).val());
                }
            });
        });

        extractionWizard.context.on("click", ".v-includeOpenEnds, .v-openEndDispositionValuesSection input:radio", function () {
            extractionWizard.validateOpenEndForControl();
        });

        extractionWizard.context.on("change", ".v-dichotomizedMultiple", function () {
            $(".v-dichotomizedMultipleOptions", extractionWizard.context).toggle($(this).is(":checked"));
        });

        extractionWizard.context.on("change", ".v-useStartNumberingRespondent", function () {
            $(".v-startNumberingRespondentAtSection", extractionWizard.context).toggle($(this).is(":checked"));
        });

        extractionWizard.context.on("change", ".v-extractAllFields", function () {
            $(".v-questionsSelectorSection", extractionWizard.context).toggle(!$(this).is(":checked"));
        });

        extractionWizard.context.on("keyup change", ".v-startNumberingRespondentAt, .v-openEndLenght", function () {
            var value = $(this).val() || 0;

            if (value < 1)
                $(this).val(1);
        });

        extractionWizard.context.on("change", "input[type='radio'][name='ExtractTaskConfiguration.UseCodeLabels']", function () {
            var hideLanguagesDropdown = $(this).val() == "True";
            $(".v-languageContainer", extractionWizard.context).toggleClass("hidden", hideLanguagesDropdown);
        });
    },
    validateOpenEndForControl: function () {
        var isChecked = $(".v-includeOpenEnds", extractionWizard.context).is(':checked');
        var isInTheRecordValue = ($(".v-openEndDispositionValuesSection input:radio:checked", extractionWizard.context).val() == "InTheRecord");

        $(".v-openEndDispositionValuesSection", extractionWizard.context).toggle(isChecked);
        $(".v-openEndLenghtSection", extractionWizard.context).toggle(isChecked && isInTheRecordValue);
    },
    variablesEqual: function (a, b) {
        return a && b && a.Name == b.Name && a.IsSystemVariable == b.IsSystemVariable;
    }
};

$(document).ready(function () {
    if (extractionWizard.context.length > 0)
    {
        extractionWizard.initialize();
        extractionWizard.bindEvents();

        extractionWizard.selectedQuestionsTable = $(".h-selectedQuestionsTable", extractionWizard.context);

        if (extractionWizard.selectedQuestionsTable.length > 0)
        {
            extractionWizard.currentData = $("#ExtractTaskConfiguration_JsonSelectedQuestions", extractionWizard.context).val() || JSON.stringify([]);
            extractionWizard.initializeDataTable();
        }
    }
});
